package com.gogirl.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.store.store.StoreTechnician;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Data
public class IdleTimeServeQuery {
    private Integer id;

    @ApiModelProperty("预约id")
    private Integer schId;

    @ApiModelProperty("预约美甲师id")
    private Integer technicianId;

    @ApiModelProperty("预约服务id")
    private Integer serveId;

    @ApiModelProperty("主服务id")
    private Integer mainServeId;

    @ApiModelProperty("0系统分配美甲师.1.客户指定美甲师")
    private Boolean isCustomerPick = false;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("样式名称")
    private String produceName;

    @ApiModelProperty("服务数量")
    private Integer serveNumber;

    @ApiModelProperty("预约款式id")
    private Integer produceId;

    @ApiModelProperty("创建用户")
    private String createUser;


    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    @ApiModelProperty("款式对象实体")
    private BaseProduce produce;

    @TableField(exist = false)
    @ApiModelProperty("用于根据前端传过来开始时间计算结束时间")
    private Integer lengthTimeForEndTime;

    @TableField(exist = false)
    @ApiModelProperty("服务实体")
    private BaseServe serve;

    @TableField(exist = false)
    @ApiModelProperty("美甲师实体")
    private StoreTechnician technicianManage;

    @TableField(exist = false)
    @ApiModelProperty("id")
    private Map<Integer, StoreTechnician> mapTechnicianManage;


    @ApiModelProperty("记录类型 0#修改 1#增加 2#删除 3#原始数据  修改时传递数据是增加还是修改")
    @TableField(exist = false)
    private Integer recordType = 0;

    @TableField(exist = false)
    @ApiModelProperty("服务分类")
    private String serveType;

    @TableField(exist = false)
    @ApiModelProperty("服务名称")
    private String serveName;

    @TableField(exist = false)
    @ApiModelProperty("是否需要卸甲卸睫毛")
    private Boolean needRemoveOldServe;

    @TableField(exist = false)
    @ApiModelProperty("")
    private List<LinkedHashMap> listTechnician;

    @TableField(exist = false)
    @ApiModelProperty("")
    private BigDecimal serveChangePrice;
}
