package com.gogirl.assembler;

import com.gogirl.domain.product.mall.MallProduct;
import com.gogirl.shared.product.MallProductDTO;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;

@Component
@AllArgsConstructor
public class MallProductDTOAssembler implements Function<MallProduct, MallProductDTO> {

    private final MallShoppingCartDTOAssembler.PurchaseSkuDTOAssembler purchaseSkuDTOAssembler;

    @Override
    public MallProductDTO apply(MallProduct mallProduct) {
        MallProductDTO mallProductDTO = new MallProductDTO();
        BeanUtils.copyProperties(mallProduct, mallProductDTO);

        return mallProductDTO;
    }
}
