package com.gogirl.interfaces.order.mall;


import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.application.order.mall.*;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.config.property.GogirlProperties;
import com.gogirl.infrastructure.config.property.WxProperties;
import com.gogirl.infrastructure.feign.wx.WxPayControllerFeign;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.net.UnknownHostException;

@Api(tags = "商城订单支付接口", value = "商城订单支付接口")
@RestController
@AllArgsConstructor
@Slf4j
public class MallOrderPayController {


    private final GogirlTokenService gogirlTokenService;
    private final MallOrderPayService mallOrderPayService;
    private final MallOrderService mallOrderService;
    private final MallOrderDetailService mallOrderDetailService;
    private final MallRefundOrderService mallRefundOrderService;
    private final MallRefundOrderDetailService mallRefundOrderDetailService;

    private final GogirlProperties gogirlProperties;
    private final WxProperties wxProperties;
    private final WxPayControllerFeign wxPayControllerFeign;

    private final CustomerMapper customerMapper;

    @ApiOperation("微信支付")
    @GetMapping("/customer/mallOrderPay/payMallOrder/{mallOrderId}")
    public JsonResult<WxPayMpOrderResult> wxPayMallOrder(@RequestHeader String token,
                                                         @PathVariable Long mallOrderId) throws UnknownHostException, WxPayException {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        WxPayMpOrderResult result = mallOrderPayService.wxPayMallOrder(currentCustomerId, mallOrderId);
        log.info("微信支付参数：{}", result);
        return JsonResult.success(result);
    }

    @ApiOperation(value = "用户端微信支付回调")
    @PostMapping("/customer/mallOrderPay/pnotifyMallOrder")
    public String notifyOrder(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);

        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            mallOrderPayService.notifyMallOrder(Long.valueOf(result.getOutTradeNo()));
        }
        return WxPayNotifyResponse.success("成功");
    }


    @ApiOperation("余额支付")
    @GetMapping("/customer/mallOrderPay/pbalancePayMallOrder/{mallOrderId}")
    public JsonResult<Integer> balancePayMallOrder(@RequestHeader String token,
                                                   @PathVariable Long mallOrderId) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        mallOrderPayService.balancePayMallOrder(currentCustomerId, mallOrderId);
        return JsonResult.success();
    }


    @ApiOperation("余额抵扣的微信支付")
    @GetMapping("/customer/mallOrderPay/pbalanceWxPayMallOrder/{mallOrderId}")
    public JsonResult<WxPayMpOrderResult> balanceWxPayMallOrder(@RequestHeader String token,
                                                                @PathVariable Long mallOrderId) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        WxPayMpOrderResult result = mallOrderPayService.balanceWxPayMallOrder(currentCustomerId, mallOrderId);
        return JsonResult.success(result);
    }

    @ApiOperation("朋友代付")
    @GetMapping("/customer/mallOrderPay/pfriendPayMallOrder/{mallOrderId}")
    public JsonResult<Integer> friendPayMallOrder(@RequestHeader String token,
                                                  @PathVariable Long mallOrderId,
                                                  @ApiParam("朋友手机号")
                                                  @RequestParam String phone) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        mallOrderPayService.friendPayMallOrder(currentCustomerId, mallOrderId, phone);
        return JsonResult.success();
    }

    @ApiOperation(("/确认退款"))
    @GetMapping("/customer/mallOrderPay/prefund/{orderDetailId}")
    @Transactional(timeout = 10000)
    public JsonResult<Void> refund(@PathVariable Long orderDetailId) throws WxPayException {
        mallRefundOrderService.refund(orderDetailId);
        return JsonResult.success();
    }
}
