package com.gogirl.shared.product.query.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class PurchaseSkuDTO {
    private Integer id;

    @ApiModelProperty("sku码")
    private String sku;

    @ApiModelProperty("图片路径,用逗号隔开多张图片")
    private String picturePath;

    @ApiModelProperty("商品名字")
    private String skuName;

    @ApiModelProperty("商品类型表的id")
    private Integer skuType;

    @ApiModelProperty("商品型号描述")
    private String skuModel;

    @ApiModelProperty("店铺看到的价格")
    private BigDecimal shopPrice;

    @ApiModelProperty("采购价格")
    private BigDecimal purchasePrice;

    @ApiModelProperty("供应商")
    private String supplier;

    @ApiModelProperty("商品类型:1.店用;2.店用+售卖")
    private Integer useType;

    @ApiModelProperty("系列id")
    private Integer seriesId;

    @ApiModelProperty("0 = 系统添加 1= 刊登系统推送 2= 百伦产品库拉取")
    private Integer source;

    @ApiModelProperty("色值")
    private String colorValue;

    @ApiModelProperty("颜色描述")
    private String colorName;

    @ApiModelProperty("色球图片")
    private String colorImgPath;

    @ApiModelProperty("最小订单量")
    private BigDecimal ppsMoq;

    @ApiModelProperty("颜色id")
    private Integer colorId;

    @ApiModelProperty("商城分类id")
    private Integer mallCategoryId;

    private PurchaseSkuTypeDTO purchaseSkuTypeDTO;


}
