package com.gogirl.infrastructure.mapper.user.customer;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.domain.user.customer.CustomerBalanceRecord;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public interface CustomerBalanceRecordMapper extends BaseMapper<CustomerBalanceRecord> {


    /**
     * 根据日期获取充值记录id和推荐人和店铺
     *
     * @param day 日期形如2020-03-03
     * @return list
     */
    List<CustomerBalanceRecord> getXcxChargeRecord(String day);

    /**
     * 查询会员卡消费记录
     *
     * @param customerId 会员ID
     * @return 记录
     */
    IPage<CustomerBalanceRecord> getBalanceRecordCard(@Param("page") IPage<CustomerBalanceRecord> page, @Param("customerId") Integer customerId);

    /**
     * 分页查询充值业绩
     *
     * @param page         page
     * @param technicianId 美甲师id
     * @param month        月份形如2020-04
     * @return page
     */
    Page<CustomerBalanceRecord> queryPageAchieve(Page<CustomerBalanceRecord> page, @Param("technicianId") Integer technicianId, @Param("month") String month);

}
