package com.gogirl.application.user.customer.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.user.customer.CustomerDetailService;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.application.xcx.QRCodeService;
import com.gogirl.application.xcx.WechatService;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderRecord;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.domain.user.customer.CustomerBalance;
import com.gogirl.domain.user.customer.CustomerDetail;
import com.gogirl.domain.xcx.GogirlConfig;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.dto.customer.CustomerOrderDetail;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderRecordMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleManageMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerDetailMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.infrastructure.mapper.xcx.GogirlConfigMapper;
import com.gogirl.infrastructure.util.WXCore;
import com.gogirl.infrastructure.util.lock.Openid1Lock;
import com.gogirl.shared.member.wx.query.dto.Code2SessionResult;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.security.InvalidAlgorithmParameterException;
import java.util.Date;
import java.util.List;

@Service
@Slf4j
public class CustomerServiceImpl extends ServiceImpl<CustomerMapper, Customer> implements CustomerService {

    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private WechatService wechatService;
    @Resource
    private GogirlTokenService gogirlTokenService;
    @Resource
    private ScheduleManageMapper scheduleManageMapper;

    @Resource
    private CustomerDetailMapper customerDetailMapper;
    @Resource
    private CustomerBalanceMapper customerBalanceMapper;

    @Resource
    private QRCodeService qrCodeService;


    @Resource
    private StoreManageMapper storeManageMapper;
    @Resource
    private OrderManageMapper orderManageMapper;

    @Resource
    private OrderServeMapper orderServeMapper;
    @Resource
    private BaseServeMapper baseServeMapper;
    @Resource
    private OrderRecordMapper orderRecordMapper;

    @Resource
    private CustomerDetailService customerDetailService;
    @Resource
    private OrderManageService orderManageService;

    @Resource
    private GogirlConfigMapper gogirlConfigMapper;

    @Override
    public Customer selectByPhone(String phone) {
        return customerMapper.selectByPhone(phone);
    }

    @Override
    public Customer selectByCustomerId(Integer scheduledUser) {
        return customerMapper.selectById(scheduledUser);
    }

    @Override
    public String login(String code) {

        log.info("调用login，授权用户信息到程序 code:{}", code);

        Openid1Lock lock = Openid1Lock.getInsatance();


        Code2SessionResult result = wechatService.getCustomerOpenidByCode(code);

        String token = IdWorker.getIdStr();

        //创建token
        GogirlToken gogirlToken = GogirlToken.builder()
                .code(code)
                .sysId(1)
                .openid(result.getOpenid())
                .sessionKey(result.getSessionKey())
                .createTime(new Date())
                .updateTime(new Date())
                .unionid(result.getUnionid())
                .token(token)
                .build();

        String openid = gogirlToken.getOpenid();

        try {
            lock.lock(openid.hashCode() & Integer.MAX_VALUE);
            //变量为当前登陆用户
            Customer customer;

            customer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getOpenid1, openid));
            //不存在小程序用户
            if (customer == null) {
                //token unionid 不为空
                if (StringUtils.isNotEmpty(result.getUnionid())) {

                    customer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getUnionid, result.getUnionid()));
                    //不存在公众号用户
                    if (customer == null) {
                        customer = Customer.builder()
                                .customerSource(4)
                                //小程序openid
                                .openid1(openid)
                                .orderTimes(0)
                                .registerTime(new Date())
                                .scheduledTimes(0)
                                //微信授权
                                .source(3)
                                //状态 正常
                                .state("1")
                                .updateTime(new Date())
                                .build();

                        customerMapper.insert(customer);
                    }
                    // 存在公众号用户
                    else {
                        customer.setOpenid1(openid);
                        customerMapper.updateById(customer);
                    }
                }
                //union id为空
                else {
                    customer = Customer.builder()
                            .customerSource(4)
                            //小程序openid
                            .openid1(openid)
                            .orderTimes(0)
                            .registerTime(new Date())
                            .scheduledTimes(0)
                            //微信授权
                            .source(3)
                            //状态 正常
                            .state("1")
                            .updateTime(new Date())
                            .build();
                    customerMapper.insert(customer);
                }

            }


            token = customer.getId() + "_" + token.substring(6);
            gogirlToken.setCustomerId(customer.getId());
            gogirlToken.setToken(token);
            gogirlTokenService.save(gogirlToken);
        } finally {
            lock.unlock(openid.hashCode() & Integer.MAX_VALUE);

        }
        return token;
    }

    @Override
    public void bindAddressInfo(Integer customerId, String province, String city, String area, String street) {
        Customer customer = customerMapper.selectById(customerId);

        customer.setProvince(province);
        customer.setCity(city);
        customer.setArea(area);
        customer.setStreet(street);
        customerMapper.updateById(customer);
    }

    @Override
    public Customer authorized1(String token, String encryptedData, String iv) throws InvalidAlgorithmParameterException {

        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
        JSONObject data = WXCore.decrypt(encryptedData, gogirlToken.getSessionKey(), iv);
        String unionid = (String) data.get("unionId");
        String openid = (String) data.get("openId");
        Integer gender = (Integer) data.get("gender");
        String avatarUrl = (String) data.get("avatarUrl");
        String city = (String) data.get("city");
        String country = (String) data.get("country");
        String province = (String) data.get("province");
        String nickName = filterEmoji((String) data.get("nickName"));

        Customer customer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getOpenid1, openid));

        customer.setSex(gender == 1 ? "男" : gender == 2 ? "女" : "未知");
        customer.setHeadimgurl(avatarUrl);
        customer.setNickname(nickName);
        customer.setProvince(province);
        customer.setCountry(country);
        customer.setCity(city);
        customer.setUnionid(unionid);
        customerMapper.updateById(customer);
        return customer;
    }

    @Override
    public Customer authorizedPhone(String token, String encryptedData, String iv) throws InvalidAlgorithmParameterException {
        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);

        JSONObject data = WXCore.decrypt(encryptedData, gogirlToken.getSessionKey(), iv);

        String phone = (String) data.get("purePhoneNumber");

        gogirlToken.setPhone(phone);
        gogirlTokenService.updateByToken(gogirlToken);

        Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());


        Customer phoneCustomer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getPhone, phone));

        //如果存在手机号
        if (phoneCustomer != null) {

            phoneCustomer.setSex(customer.getSex());
            phoneCustomer.setHeadimgurl(customer.getHeadimgurl());
            phoneCustomer.setNickname(customer.getNickname());
            phoneCustomer.setProvince(customer.getProvince());
            phoneCustomer.setCountry(customer.getCountry());
            phoneCustomer.setCity(customer.getCity());
            phoneCustomer.setUnionid(customer.getUnionid());

            phoneCustomer.setCustomerSource(customer.getCustomerSource());
            phoneCustomer.setOpenid1(customer.getOpenid1());
            phoneCustomer.setRegisterTime(customer.getRegisterTime());
            phoneCustomer.setScheduledTimes(customer.getScheduledTimes());
            phoneCustomer.setSource(customer.getSource());
            phoneCustomer.setState(customer.getState());
            phoneCustomer.setUpdateTime(new Date());

            customerMapper.deleteById(customer);
            customerMapper.updateById(phoneCustomer);

            List<ScheduleManage> scheduleManageList = scheduleManageMapper.selectList(new LambdaQueryWrapper<ScheduleManage>()
                    .eq(ScheduleManage::getTelephone, phone));
            if (ListUtil.isNotEmpty(scheduleManageList)) {
                scheduleManageList.forEach(scheduleManage -> {
                    scheduleManage.setTelephone(phone);
                    scheduleManageMapper.updateById(scheduleManage);
                });
            }
            //清除token
            gogirlTokenService.remove(token);
            return phoneCustomer;
        }
        //不存在手机号
        else {
            customer.setPhone(phone);
            customerMapper.updateById(customer);
            return customer;
        }
    }

    @Override
    public Customer getUserInfo(String token) throws Exception {
        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);

        Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());
        CustomerDetail customerDetail = customerDetailMapper.selectOne(new LambdaQueryWrapper<CustomerDetail>().eq(CustomerDetail::getCustomerId, customer.getId()));
        CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>().eq(CustomerBalance::getCustomerId, customer.getId()));


        customer.setCustomerDetail(customerDetail);
        customer.setCustomerBalance(customerBalance);

        if (StringUtils.isEmpty(customer.getMyQrcode()) && StringUtils.isNotEmpty(customer.getPhone())) {
            String myQrCode = qrCodeService.myQrCode(customer.getId().toString(), customer.getPhone());
            customer.setMyQrcode(myQrCode);
            customer.setId(customer.getId());
            customer.setMyQrcode(myQrCode);
            customerMapper.updateById(customer);
        }

        return customer;
    }

    @Override
    public CustomerOrderDetail queryCustomerDetail(Integer customerId, Integer orderId) {

        CustomerOrderDetail customerOrderDetail = new CustomerOrderDetail();

        //查询用户信息
        Customer customer = customerMapper.selectById(customerId);

        //查询用户注册店铺
        StoreManage storeManage = storeManageMapper.selectById(customer.getRegisterDepartment());
        customer.setStoreManage(storeManage);

        //查询余额
        CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>().eq(CustomerBalance::getCustomerId, customerId));
        customer.setCustomerBalance(customerBalance);

        //查询会员详情
        CustomerDetail customerDetail = customerDetailMapper.selectOne(new LambdaQueryWrapper<CustomerDetail>().eq(CustomerDetail::getCustomerId, customer.getId()));
        customer.setCustomerDetail(customerDetail);
        customerOrderDetail.setCustomer(customer);

        if (orderId != null) {
            //查询订单信息
            OrderManage orderManage = orderManageMapper.selectById(orderId);

            List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderId));
            orderManage.setListOrderServer(orderServeList);

            orderServeList.forEach(orderServe -> {
                OrderRecord orderRecord = orderRecordMapper.selectOne(new LambdaQueryWrapper<OrderRecord>().eq(OrderRecord::getOrderServeId, orderServe.getId()));
                BaseServe baseServe = baseServeMapper.selectById(orderServe.getServeId());
                orderServe.setOrderRecord(orderRecord);
                orderServe.setServe(baseServe);
            });

            customerOrderDetail.setOrderManage(orderManage);
        }

        return customerOrderDetail;
    }

    @Override
    public void updateCustomerDetail(Integer birthdayMonth, Integer birthdayDay, String ageGroup, Integer customerId, Integer orderId, Integer orderServeId, String storeRecordRealName, String sex, Integer age, String job, String preference, String character, Integer customerSource) {

        //用户基本信息
        Customer customer = customerMapper.selectById(customerId);
        customer.setStoreRecordRealName(storeRecordRealName);
        customer.setSex(sex);
        customer.setCustomerSource(customerSource);
        customerMapper.updateById(customer);


        //用户详情信息
        CustomerDetail customerDetail = customerDetailMapper.selectOne(new LambdaQueryWrapper<CustomerDetail>().eq(CustomerDetail::getCustomerId, customer.getId()));
        if (customerDetail == null) {
            customerDetail = new CustomerDetail();
        }
        customerDetail.setCustomerId(customerId);
        customerDetail.setAge(age);
        customerDetail.setJob(job);
        customerDetail.setPreference(preference);
        customerDetail.setCharacter(character);
        customerDetail.setBirthdayMonth(birthdayMonth);
        customerDetail.setBirthdayDay(birthdayDay);
        customerDetail.setAgeGroup(ageGroup);

        customerDetailService.saveOrUpdate(customerDetail);


        //更新数据完整度
        customer.setDataIntegrity(this.countDataCompleteRate(customer, customerDetail));
        customerMapper.updateById(customer);

        if (orderId != null) {
            OrderManage om = orderManageService.queryOrder(orderId);

            double dataRate = orderManageService.countOrderDataRate(customer, om);
            om.setDataIntegrity(dataRate);
            orderManageService.updateOrderDataIntegrity(om);
        }
    }

    @Override
    public List<String> getAgeGroups() {
        GogirlConfig gogirlConfig = gogirlConfigMapper.selectByPrimaryKey(3);
        if (gogirlConfig == null || gogirlConfig.getValue() == null || gogirlConfig.getValue().isEmpty()) {
            throw new RRException("请联系管理员,在gogirl_config表中配置id=3的value,用英文逗号隔开多个选项");
        }
        String[] ageGroups = gogirlConfig.getValue().split(",");
        return Lists.newArrayList(ageGroups);
    }

    @Override
    public String h5Login(Integer orderId) {
        OrderManage orderManage = orderManageMapper.selectById(orderId);
        if (orderManage == null) {
            throw new RRException("订单不存在");
        }
        Customer customer = customerMapper.selectById(orderManage.getOrderUser());
        if (customer == null) {
            throw new RRException("订单用户不存在");
        }
        String token = customer.getId() + "_" + IdWorker.getIdStr().substring(6);
        GogirlToken gogirlToken = GogirlToken.builder()
                .customerId(customer.getId())
                .openid(customer.getOpenid1())
                .createTime(new Date())
                .token(token)
                .sysId(1)
                .phone(customer.getPhone())
                .build();

        gogirlTokenService.save(gogirlToken);
        return token;
    }

    @Override
    public Customer getByOpenid1(String openid) {
        return customerMapper.selectOne(new LambdaQueryWrapper<Customer>()
                .eq(Customer::getOpenid1, openid));
    }


    /**
     * 计算客户资料完整度
     *
     * @param c
     * @param record
     * @return
     */
    @Override
    public Double countDataCompleteRate(Customer c, CustomerDetail record) {
        BigDecimal rate = new BigDecimal("0");
        BigDecimal per10 = new BigDecimal("0.1");
        BigDecimal per4 = new BigDecimal("0.04");

        if (c.getCustomerSource() != null && c.getCustomerSource() != 0) {
            rate = rate.add(per10);
            rate = rate.add(per10);
            rate = rate.add(per10);
        } else {
            if (c.getStoreRecordRealName() != null && !c.getStoreRecordRealName().isEmpty()) {
                rate = rate.add(per10);
            }
            if (c.getPhone() != null && !c.getPhone().isEmpty()) {
                rate = rate.add(per10);
            }
        }
        if (record != null && record.getQuestionnaireImgUrl() != null && !record.getQuestionnaireImgUrl().isEmpty()) {
            rate = rate.add(per10);
        }

        if (record != null && record.getWechatId() != null && !record.getWechatId().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getReferee() != null && !record.getReferee().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getFirstServeTime() != null && !record.getFirstServeTime().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getBirthday() != null && !record.getBirthday().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getMaritalStatus() != null && !record.getMaritalStatus().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getHaveChildren() != null && !record.getHaveChildren().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getHobby() != null && !record.getHobby().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getColourOfSkin() != null && !record.getColourOfSkin().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getTypeOfNailBed() != null && !record.getTypeOfNailBed().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getNailType() != null && !record.getNailType().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getKeyPointsOfSalon() != null && !record.getKeyPointsOfSalon().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getLikeStyle() != null && !record.getLikeStyle().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getCustomerConcerns() != null && !record.getCustomerConcerns().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getSolution() != null && !record.getSolution().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getEyelashCondition() != null && !record.getEyelashCondition().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getEyeShape() != null && !record.getEyeShape().isEmpty()) {
            rate = rate.add(per4);
        }
        if (record != null && record.getLearnAboutUs() != null && !record.getLearnAboutUs().isEmpty()) {
            rate = rate.add(per10);
        }
        if (record != null && record.getAge() != null && record.getAge() != 0) {
            rate = rate.add(per4);
        }
        if (record != null && record.getNailHardness() != null && record.getNailHardness() != 0) {
            rate = rate.add(per4);
        }
        if (record != null && record.getResidence() != null && record.getResidence() != 0) {
            rate = rate.add(per10);
        }
        if (record != null && record.getWorkAddress() != null && record.getWorkAddress() != 0) {
            rate = rate.add(per10);
        }
        if (record != null && record.getOccupation() != null && record.getOccupation() != 0) {
            rate = rate.add(per4);
        }
        if (record != null && record.getFrequencyOfNail() != null && record.getFrequencyOfNail() != 0) {
            rate = rate.add(per10);
        }

        if (rate.compareTo(new BigDecimal("1")) >= 0) {
            return 1.0;
        } else {
            return rate.doubleValue();
        }
    }


    /**
     * 将emoji表情替换成空串
     *
     * @param source
     * @return 过滤后的字符串
     */
    private static String filterEmoji(String source) {
        if (source != null && source.length() > 0) {
            return source.replaceAll("[\ud800\udc00-\udbff\udfff\ud800-\udfff]", "");
        } else {
            return source;
        }
    }
}
