package com.gogirl.application.store.store;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.domain.store.oa.TakeLeaveEvent;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.shared.store.ApplyTakeLeaveCommand;
import com.gogirl.shared.store.ApprovalTakeLeaveCommand;
import com.gogirl.shared.store.PageApplyQuery;

import java.util.List;

public interface TakeLeaveEventCmdService {

    /**
     * 申请请假
     *
     * @param cmd
     */
    void applyTakeLeave(ApplyTakeLeaveCommand cmd);

    /**
     * 审批请假
     *
     * @param cmd
     */
    void approvalTakeLeave(ApprovalTakeLeaveCommand cmd);

    /**
     * 查询请假详情
     *
     * @param id
     * @return
     */
    TakeLeaveEvent queryTakeLeave(Long id);

    /**
     * 分页查询请假接口
     *
     * @param qry
     * @return
     */
    IPage<TakeLeaveEvent> queryPageTakeLeave(PageApplyQuery qry);

    /**
     * 查询可以审核人员列表
     *
     * @param id
     * @param departmentId
     * @return
     */
    List<StoreTechnician> queryCheckTechnicianList(Integer id, Integer departmentId);

    /**
     * 总后台驳回请假
     *
     * @param takeLeaveEventId
     */
    void adminRefuseTakeLeaveEvent(Integer takeLeaveEventId);
}
