package com.gogirl.interfaces.xcx;

import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.gogirl.application.order.serve.PayService;
import com.gogirl.domain.market.serve.TimesCardCustomerRelevance;
import com.gogirl.domain.market.serve.TimesCardType;
import com.gogirl.infrastructure.mapper.market.TimesCardCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.TimesCardTypeMapper;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * @Author robbendev
 * @Description //TODO
 * @Date 2019/12/29
 **/
@RestController
@AllArgsConstructor
@Slf4j
public class WxCallbackController {

    private final PayService payService;
    private final TimesCardTypeMapper timesCardTypeMapper;
    private final TimesCardCustomerRelevanceMapper timesCardCustomerRelevanceMapper;

    @ApiOperation(value = "预约订单微信支付回调")
    @RequestMapping(method = {RequestMethod.POST}, value = "/customer/pay/notifyOrder")
    public String notifyOrder(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);

        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            //微信支付
            payService.notifyOrder(result.getOutTradeNo(), 1);
        }
        return WxPayNotifyResponse.success("成功");
    }

    @ApiOperation(value = "微信余额支付回调")
    @RequestMapping(method = {RequestMethod.POST}, value = "/customer/pay/notifyBalanceWxPay")
    public String notifyBalanceWxPay(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);

        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            payService.notifyBalanceWxPay(result.getOutTradeNo());
        }
        return WxPayNotifyResponse.success("成功");
    }

    @ApiOperation(value = "余额充值微信支付回调")
    @RequestMapping(method = {RequestMethod.POST}, value = "/customer/pay/notifyCharge")
    public String notifyCharge(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);

        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            payService.notifyCharge(result);
        }
        return WxPayNotifyResponse.success("成功");
    }

    @ApiOperation(value = "购买次卡微信支付回调")
    @RequestMapping(method = {RequestMethod.POST}, value = "/customer/pay/notifyTimesCard")
    public String notifyTimesCard(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);

        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            String attach = result.getAttach();
            String timesCardIdString = attach.split(",")[0];
            String customerIdString = attach.split(",")[1];
            Integer timesCardTypeId = Integer.parseInt(timesCardIdString);
            Integer customerId = Integer.parseInt(customerIdString);


            TimesCardType timesCardType = timesCardTypeMapper.selectById(timesCardTypeId);
            TimesCardCustomerRelevance timesCardCustomerRelevance = TimesCardCustomerRelevance.builder()
                    .cardTypeId(timesCardTypeId)
                    .name(timesCardType.getName())
                    .customerId(customerId)
                    .sumTimes(timesCardType.getSumTimes())
                    .usedTimes(0)
                    .createTime(new Date())
                    .discountAmount(timesCardType.getDiscountAmount())
                    .payAmount(timesCardType.getPayAmount())
                    .refereeId(null)
                    .status(TimesCardCustomerRelevance.STATUS_NORMAL)
                    .validStartTime(new Date())
                    .validEndTime(new Date(System.currentTimeMillis() + timesCardType.getValidDays() * 24 * 60 * 60 * 1000L))
                    .build();

            timesCardCustomerRelevanceMapper.insert(timesCardCustomerRelevance);
        }
        return WxPayNotifyResponse.success("成功");
    }
}
