package com.gogirl.interfaces.order.mall;

import com.gogirl.application.order.mall.MallCustomerAddressService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.order.mall.MallCustomerAddress;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@Api(tags = "version3.0:收获地址接口", value = "version3.0:收获地址接口")
@RestController
@AllArgsConstructor
public class MallCustomerAddressController {

    private final MallCustomerAddressService mallCustomerAddressService;
    private final GogirlTokenService gogirlTokenService;


    @ApiOperation("新增收获地址")
    @PostMapping("/customer/customerAddress/addMallCustomerAddress")
    public JsonResult<MallCustomerAddress> addMallCustomerAddress(@RequestHeader String token,
                                                                  @RequestBody MallCustomerAddress mallCustomerAddress) {
        Integer currentCustomerId = SessionUtils.getCustomer().getId();
        mallCustomerAddress.setCustomerId(currentCustomerId);
        mallCustomerAddress.setIsDefault(MallCustomerAddress.IS_DEFAULT_FALSE);
        mallCustomerAddressService.addMallCustomerAddress(mallCustomerAddress);
        return JsonResult.success(mallCustomerAddress);
    }

    @ApiOperation("修改收货地址")
    @PostMapping("/customer/customerAddress/changeMallCustomerAddress")
    public JsonResult<MallCustomerAddress> changeMallCustomerAddress(@RequestHeader String token,
                                                                     @RequestBody MallCustomerAddress mallCustomerAddress) {
        Integer currentCustomerId = SessionUtils.getCustomer().getId();
        mallCustomerAddress.setCustomerId(currentCustomerId);
        mallCustomerAddressService.changeMallCustomerAddress(mallCustomerAddress);
        return JsonResult.success(mallCustomerAddress);
    }

    @ApiOperation("收获地址列表")
    @GetMapping("/customer/customerAddress/listMallCustomerAddress")
    public JsonResult<List<MallCustomerAddress>> listMallCustomerAddress(@RequestHeader String token) {
        Integer currentCustomerId = SessionUtils.getCustomer().getId();
        List<MallCustomerAddress> list = mallCustomerAddressService.listMallCustomerAddress(currentCustomerId);
        return JsonResult.success(list);
    }

    @ApiOperation("修改默认收货地址")
    @GetMapping("/customer/customerAddress/updateDefaultMallCustomerAddress/{mallCustomerAddressId}")
    public JsonResult<MallCustomerAddress> updateDefaultMallCustomerAddress(@RequestHeader String token,
                                                                            @PathVariable Long mallCustomerAddressId) {
        Integer currentCustomerId = SessionUtils.getCustomer().getId();
        MallCustomerAddress mallCustomerAddress = mallCustomerAddressService.updateDefaultMallCustomerAddress(currentCustomerId, mallCustomerAddressId);
        return JsonResult.success(mallCustomerAddress);
    }


    @ApiOperation("获取默认收货地址")
    @GetMapping("/customer/customerAddress/getDefaultMallCustomerAddress")
    public JsonResult<MallCustomerAddress> getDefaultMallCustomerAddress(@RequestHeader String token) {
        Integer currentCustomerId = SessionUtils.getCustomer().getId();
        MallCustomerAddress mallCustomerAddress = mallCustomerAddressService.getDefaultMallCustomerAddress(currentCustomerId);
        return JsonResult.success(mallCustomerAddress);
    }
}
