package com.gogirl.infrastructure.interceptor;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.Customer;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Component
@AllArgsConstructor
@Slf4j
public class LoginHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;
    private final CustomerService customerService;

    private final StoreTechnicianMapper storeTechnicianMapper;
    private final StoreManageMapper storeManageMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        String token = request.getHeader("token");

        if (request.getRequestURI().contains("no_")) {
            return true;
        }

        String sourceFrom = request.getHeader("sourceFrom");
        if (sourceFrom == null) {
            return true;
        }
        if (sourceFrom.equals("customer")) {
            GogirlToken gogirlToken = gogirlTokenService.getOne(new LambdaQueryWrapper<GogirlToken>().eq(GogirlToken::getToken, token));
            if (gogirlToken == null) {
                throw new RRException(2000, "token失效，请重新登陆");
            } else {
                Customer customer = customerService.getById(gogirlToken.getCustomerId());
                if (customer == null) {
                    throw new RRException(2000, "token失效，请重新登陆");
                } else {
                    SessionUtils.putCustomer(customer);
                }
            }
        }
        if (sourceFrom.equals("technician")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken == null) {
                throw new RRException(2000, "token失效，请重新登陆");
            } else {
                StoreTechnician storeTechnician = storeTechnicianMapper.selectById(gogirlToken.getTechnicianId());
                if (storeTechnician == null) {
                    throw new RRException(2000, "token失效，请重新登陆");
                }
                if (gogirlToken.getDepartmentId() == null) {
                    List<StoreManage> storeManageList = storeManageMapper.getTechnicianShopList(storeTechnician.getId());
                    if (ListUtil.isNotEmpty(storeManageList) && storeManageList.size() == 1) {
                        StoreManage storeManage = storeManageList.get(0);
                        gogirlToken.setDepartmentId(storeManage.getId());
                        gogirlTokenService.updateById(gogirlToken);
                    } else {
                        throw new RRException(2005, "请选择店铺");
                    }
                }

                storeTechnician.setTechnicianId(storeTechnician.getId());
                storeTechnician.setDepartmentId(gogirlToken.getDepartmentId());
                SessionUtils.putStoreTechnician(storeTechnician);
            }
        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SessionUtils.removeCustomer();
        SessionUtils.removeStoreTechnician();
    }
}
