package com.gogirl.domain.store.store;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.shared.store.query.dto.StoreTechnicianDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by yinyong on 2018/9/18.
 */

@Data
@TableName("store_technician")
@ApiModel("美甲师")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class StoreTechnician {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @TableField(exist = false)
    private Integer technicianId;

    private String openid;

    private String picturePath;

    @ApiModelProperty("技师编号")
    private String technicianNo;

    @ApiModelProperty("姓名")
    private String name;

    @TableField(exist = false)
    @ApiModelProperty("店铺编号")
    private Integer departmentId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("用户权限")
    private String userAuthority;

    @ApiModelProperty("级别")
    private String grade;

    @ApiModelProperty("资历")
    private Double seniority;

    @ApiModelProperty("信息填写完整度")
    private Double informationIntegrity;

    @ApiModelProperty("投诉次数")
    private Integer complaintNumber;

    @ApiModelProperty("投诉原因")
    private String complaintReason;

    @ApiModelProperty("投诉次数")
    private Integer serviceNumberTotal;

    @ApiModelProperty("服务次数")
    private BigDecimal serviceMoneyTotal;

    @ApiModelProperty("累计服务金额")
    private BigDecimal applyCardMoneyTotal;

    @ApiModelProperty("分数")
    private Double score;

    @ApiModelProperty("员工id store_user表id")
    private Integer userId;

    private String shortCode;

    @TableField(exist = false)
    @ApiModelProperty("发消息模板时,被预约项目")
    private String serveName;

    @ApiModelProperty("状态： 1#在职 2#离职")
    private Integer status = 0;

    @TableField(exist = false)
    @ApiModelProperty("发消息模板时,被预约时间")
    private Date time;

    @TableField(exist = false)
    private String jobs;

    @TableField(exist = false)
    @ApiModelProperty("每天的排班记录")
    private StoreClassesTechnician classesTechnician;

    @TableField(exist = false)
    @ApiModelProperty("预约的服务")
    private List<ScheduleServe> listScheduleServer;

    @ApiModelProperty("店铺名")
    @TableField(exist = false)
    private String departmentName;

    @TableField(exist = false)
    private StoreTechnicianDTO applyStoreTechnicianDTO;

}
