package com.gogirl.interfaces.user;

import com.gogirl.application.market.MarketService;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.shared.market.command.SetTimesCardCommand;
import com.gogirl.shared.market.command.SetUpInnerCouponCommand;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@Api(tags = {"version 3.0: 优惠券"})
@Slf4j
@AllArgsConstructor
public class CouponOrderRelevanceController {

    private final MarketService marketService;

    @ApiOperation(value = "用户提交优惠券")
    @PostMapping(value = "/customer/submitCoupons")
    public JsonResult<Void> submitCoupons(@RequestParam Integer orderId,
                                          @RequestParam String couponRelevanceIds,
                                          @RequestParam String timesCardIds) {

        log.info("用户提交优惠券 orderId:{},couponIds:{}", orderId, couponRelevanceIds);

        List<Integer> innerCouponIds = StringUtils.isNotEmpty(couponRelevanceIds)
                ? Lists.newArrayList(couponRelevanceIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList())
                : Lists.newArrayList();

        marketService.setUpInnerCoupon(SetUpInnerCouponCommand.builder()
                .innerCouponCustomerRelevanceIds(innerCouponIds)
                .orderId(orderId)
                .build());

        List<Integer> timesCardCustomerIds = StringUtils.isNotEmpty(timesCardIds)
                ? Lists.newArrayList(timesCardIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList())
                : Lists.newArrayList();

        marketService.setTimesCard(SetTimesCardCommand.builder()
                .orderId(orderId)
                .timesCardIds(timesCardCustomerIds)
                .build());

        marketService.setterOrder(orderId);
        return JsonResult.success();
    }
}
