package com.gogirl.interfaces.order.mall;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.order.mall.MallRefundOrderService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.order.mall.MallRefundOrder;
import com.gogirl.domain.order.mall.RefundReasonConfig;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.mapper.order.mall.RefundReasonConfigMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.market.RefundOrderByDetailIdRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/mallRefundOrder")
@AllArgsConstructor
@Api(tags = "version3.0:商城退款订单接口", value = "version3.0:商城退款订单接口")
public class MallRefundOrderController {

    private final MallRefundOrderService mallRefundOrderService;
    private final GogirlTokenService gogirlTokenService;
    private final RefundReasonConfigMapper refundReasonConfigMapper;

    @ApiOperation("申请退款")
    @PostMapping("/customer/mallRefundOrder/refundOrder")
    public JsonResult<Integer> refundOrder(@RequestHeader String token,
                                           @RequestBody MallRefundOrder mallRefundOrder) {
        Integer currentCustomerId = SessionUtils.getCustomer().getId();

        mallRefundOrder.setCustomerId(currentCustomerId);
        mallRefundOrderService.refundOrder(mallRefundOrder);
        return JsonResult.success();
    }


    //申请根据详情退款
    @ApiOperation("根据详情退款")
    @PostMapping("/customer/mallRefundOrder/refundOrderByDetailId")
    public JsonResult<Void> refundOrderByDetailId(@RequestHeader String token,
                                                  @RequestBody RefundOrderByDetailIdRequest request) {
        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
        request.setCustomerId(gogirlToken.getCustomerId());
        mallRefundOrderService.refundOrderByDetailId(request);
        return JsonResult.success();
    }

    @ApiOperation("申请退款")
    @GetMapping("/customer/mallRefundOrder/applyRefundOrder")
    public JsonResult<Void> applyRefundOrder(@RequestHeader String token,
                                             @PathVariable Long orderDetailId) {
        return JsonResult.success();
    }

    @ApiOperation("退款理由列表")
    @GetMapping("/customer/mallRefundOrder/queryRefundReason")
    public JsonResult<List<RefundReasonConfig>> queryRefundReason() {
        List<RefundReasonConfig> list = refundReasonConfigMapper.selectList(new LambdaQueryWrapper<>());
        return JsonResult.success(list);
    }
}
