package com.gogirl.infrastructure.mapper.store;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.store.store.StoreData;
import com.gogirl.domain.store.store.StoreTechnicianAchieve;
import com.gogirl.domain.store.store.StoreTradeAmount;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;


public interface StoreDataMapper extends BaseMapper<StoreData> {
    /**
     * 查询当月充卡数量
     *
     * @param technicianId
     * @param month
     * @return
     */
    Integer queryMonthBalanceCardNum(@Param("departmentId") Integer departmentId, @Param("month") String month);

    /**
     * 查询当月订单总数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryMonthOrderNum(@Param("departmentId") Integer departmentId, @Param("month") String month);

    /**
     * 查询当月服务客户数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryMonthServeCustomerNum(@Param("departmentId") Integer departmentId, @Param("month") String month);

    /**
     * 查询总充卡数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryTotalBalanceCardNum(@Param("departmentId") Integer departmentId, @Param("month") String month);

    /**
     * 查询总服务客户数量
     *
     * @param departmentId
     * @param month
     * @return
     */
    Integer queryTotalServeCustomerNum(@Param("departmentId") Integer departmentId, @Param("month") String month);

    /**
     * 查询总订单数量
     *
     * @param departmentId
     * @param month
     * @return
     */
    Integer queryTotalOrderNum(@Param("departmentId") Integer departmentId, @Param("month") String month);


    /**
     * 查询当月复购单数量
     *
     * @param departmentId
     * @param month
     * @return
     */
    Integer queryMonthAgainOrderNum(@Param("departmentId") Integer departmentId, @Param("month") String month);


    /**
     * 查询总复购单数量
     *
     * @param departmentId
     * @param month
     * @return
     */
    Integer queryTotalAgainOrderNum(@Param("departmentId") Integer departmentId, @Param("month") String month);


    BigDecimal queryMonthOrderServeAmount(@Param("serveType") Integer serveType, @Param("month") String month);

    List<StoreTradeAmount> storeTradeAmount(@Param("month") String month);

    List<StoreTechnicianAchieve> storeTechnicianAchieve(String month);

    BigDecimal chargeAchieve(String month);
}
