package com.gogirl.shared.market.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CouponCustomerRelevanceDTO {
    private Integer id;

    @ApiModelProperty("用户id")
    private Integer customerId;

    private String couponName;

    private String couponNote;

    @ApiModelProperty("优惠券配置id")
    private Integer couponId;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("满这个金额才能减")
    private BigDecimal reachingAmount;

    @ApiModelProperty("优惠折扣")
    private BigDecimal discountPercent;

    @ApiModelProperty("优惠券类型:1.现金抵扣券;2.免单券；3满减券；4卸甲券")
    private Integer type;

    @ApiModelProperty("0 = 内部券 1 = 外部券")
    private Integer sourceType;

    @ApiModelProperty("使用条件:1.重叠使用")
    private String condition1;

    @ApiModelProperty("客户购买该券时，实际支付的金额(用该金额算业绩)")
    private BigDecimal payAmount;

    @ApiModelProperty("该优惠券使用状态1.正常,2.已使用,3.已过期")
    private Integer state;

    @ApiModelProperty("领券时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date receiveTime;

    @ApiModelProperty("有效期开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validStartTime;

    @ApiModelProperty("有效期结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validEndTime;

    @ApiModelProperty("优惠券使用日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date useDate;

    @ApiModelProperty("备注")
    private String remark;

}
