package com.gogirl.domain.store.oa;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 加班记录
 */
@TableName("over_time_record")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OverTimeRecord implements Serializable {


    @JsonSerialize(using = ToStringSerializer.class)
    @TableId(type = IdType.AUTO)
    private Long id;

    @ApiModelProperty("加班记录")
    private Integer technicianId;

    @ApiModelProperty("开始时间")
    private Long startTime;

    @ApiModelProperty("结束时间")
    private Long endTime;

    @ApiModelProperty("剩余调休时间")
    private BigDecimal leftTimeLength;

    @ApiModelProperty("总调休时间")
    private BigDecimal totalTimeLength;

    @ApiModelProperty("是否可以调休 1-是 2-否")
    private Integer status;

    private Long createTime;

    private Long lastUpdateTime;

    private Long takeLeaveEventId;

    @ApiModelProperty("品牌ID")
    private Integer brandId;


}
