package com.gogirl.application.market.coupon;

import java.util.List;

public interface MarketService {

    /**
     * 预约订单使用内部券
     *
     * @param orderId
     * @param innerCouponIds
     */
    void setUpInnerCoupon(Integer orderId, List<Integer> innerCouponIds);

    /**
     * 预约订单使用外部券
     *
     * @param orderId
     * @param outerCouponIds
     */
    void setUpOuterCoupon(Integer orderId, List<Integer> outerCouponIds, Integer orderUser);

    /**
     * 预约使用次卡
     *
     * @param orderId
     * @param timesCardCustomerIds
     */
    void setTimesCard(Integer orderId, List<Integer> timesCardCustomerIds);

    /**
     * 预约订单完成支付
     * <p>
     * 订单支付完成后调用这个方法更新订单关联的卡券状态
     * </p>
     *
     * @param orderId
     */
    void finishPayOrder(Integer orderId, Integer brandId);

    /**
     * 计算订单金额
     * <p>
     * 使用卡券次卡使用使用该方法计算订单的实际金额和折扣金额并持久到数据库
     * </p>
     *
     * @param orderId
     */
    void calcOrderAmount(Integer orderId);

    /**
     * 自动选券
     *
     * @param couponCustomerRelevanceId
     */
    void asyncAutoSetCoupon(Integer couponCustomerRelevanceId, Integer orderId);


    /**
     * @param orderId
     */
    void achievementReCalc(Integer orderId);

    /**
     * @param orderId
     */
    void orderAmountReCalc(Integer orderId);
}
