package com.gogirl.interfaces.store.training;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.application.store.training.ITrainingStartClassLogTechnicianService;
import com.gogirl.domain.store.training.TrainingStartClassLogTechnician;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.store.training.QueryPageStartClassLogRequest;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 每次开课，参与的美甲师 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@RestController
public class TrainingStartClassLogTechnicianController {
    @Resource
    ITrainingStartClassLogTechnicianService trainingStartClassLogTechnicianService;

    @ApiOperation("培训记录")
    @GetMapping("/technician/career/queryPageStartClassLog")
    public JsonResult<IPage<TrainingStartClassLogTechnician>> queryPageStartClassLog(QueryPageStartClassLogRequest request) {


        IPage<TrainingStartClassLogTechnician> page = trainingStartClassLogTechnicianService.queryPageStartClassLog(request);
        return JsonResult.success(page);
    }

}
