package com.gogirl.interfaces.store.training;


import com.gogirl.application.store.training.ITrainingQuestionService;
import com.gogirl.domain.store.training.TrainingQuestion;
import com.gogirl.infrastructure.common.base.JsonResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@RestController
@RequestMapping("/technician/trainingQuestion")
public class TrainingQuestionController {

    @Resource
    ITrainingQuestionService trainingQuestionService;


    @GetMapping("/trainingFeedbackQuestions")
    public JsonResult<List<TrainingQuestion>> trainingFeedbackQuestions() {
        List<TrainingQuestion> trainingQuestionList = trainingQuestionService.trainingFeedbackQuestions();
        return JsonResult.success();
    }


}
