package com.gogirl.application.order.serve.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.serve.OrderServeService;
import com.gogirl.domain.order.serve.OrderRecord;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.order.serve.OrderServeDescribe;
import com.gogirl.domain.order.serve.OrderServeSku;
import com.gogirl.infrastructure.mapper.order.serve.OrderRecordMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeDescribeMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeSkuMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yinyong on 2018/11/19.
 */
@Service
@AllArgsConstructor
public class OrderServeServiceImpl extends ServiceImpl<OrderServeMapper, OrderServe> implements OrderServeService {

    private final OrderServeMapper orderServeMapper;
    private final OrderServeSkuMapper orderServeSkuMapper;
    private final OrderServeDescribeMapper orderServeDescribeMapper;
    private final OrderRecordMapper orderRecordMapper;

    @Override
    public OrderServe getOrderServeDetail(Integer id) {
        OrderServe orderServe = orderServeMapper.selectById(id);
        List<OrderServeSku> orderServeSkuList = orderServeSkuMapper.selectList(new LambdaQueryWrapper<OrderServeSku>().eq(OrderServeSku::getOrderServeId, orderServe.getId()));
        List<OrderServeDescribe> orderServeDescribeList = orderServeDescribeMapper.selectByOrderServeId(orderServe.getId());

        OrderRecord orderRecord = orderRecordMapper.selectOne(new LambdaQueryWrapper<OrderRecord>()
                .eq(OrderRecord::getOrderServeId, id));
        orderServe.setListOrderServeSku(orderServeSkuList);
        orderServe.setListOrderServeDescribe(orderServeDescribeList);
        orderServe.setOrderRecord(orderRecord);
        return orderServe;
    }

}
