package com.gogirl.infrastructure.common.base;

/**
 * Created by yinyong on 2018/9/17.
 */
public class JsonResult<T> {



    public static final boolean CODE_SUCCESS = true;
    public static final boolean CODE_ERROR = false;


    public static final String APP_DEFINE_ERR = "参数错误或者操作未成功";// 返回信息-失败
    public static final String APP_DEFINE_SUC = "操作成功";// 返回信息-成功


    private boolean success;    // 返回状态
    private int code;       //返回状态码
    private String message;   //返回信息
    private T data;          // 返回数据

    public JsonResult() {
        this.success = CODE_SUCCESS;
        this.code = 200;
        this.message = APP_DEFINE_SUC;
    }

    public JsonResult(boolean success) {
        this.success = success;
        if (success) {
            this.message = APP_DEFINE_SUC;
        } else {
            this.message = APP_DEFINE_ERR;
        }
    }

    public JsonResult(boolean success, String message) {
        this.success = success;
        this.message = message;
    }

    public JsonResult(boolean success, String message, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
    }

    public JsonResult(boolean success, int code, String message, T data) {
        this.success = success;
        this.code = code;
        this.message = message;
        this.data = data;
    }


    public static <T> JsonResult<T> success() {
        return new JsonResult<>(CODE_SUCCESS, 200, APP_DEFINE_SUC, null);
    }

    public static <T> JsonResult<T> success(T data) {
        return new JsonResult<>(CODE_SUCCESS, 200, APP_DEFINE_SUC, data);
    }

    public boolean getSuccess() {
        return success;
    }

    public JsonResult<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public JsonResult<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public T getData() {
//        if (code != 200) {
//            throw new RRException(code, message);
//        }
        return data;
    }

    public JsonResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    @Override
    public String toString() {
        return "JsonResult [success=" + success + ", message=" + message
                + ", data=" + data + "]";
    }


    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
