package com.gogirl.domain.user.customer;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.gogirl.infrastructure.common.annotation.DictParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-07-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BeautyExpoQuestionnaire对象", description = "")
public class BeautyExpoQuestionnaire implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "小程序用户id")
    private Integer customerId;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "城市")
    private String city;

    @ApiModelProperty(value = "职业")
    private String profession;

    @ApiModelProperty(value = "意向")
    private String intention;

    @ApiModelProperty(value = "1-领取礼品 2-领取课程")
    @DictParam(dictCode = "BEAUTY_EXPO_QUESTIONNAIRE_TYPE",dictValueParam = "typeStr")
    private Integer type;

    @ApiModelProperty(value = "1-领取礼品 2-领取课程")
    @TableField(exist = false)
    private String typeStr;

}
