package com.gogirl.application.order.serve.impl;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.serve.OrderRecordService;
import com.gogirl.domain.order.serve.OrderRecord;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.order.serve.OrderRecordMapper;
import com.gogirl.shared.order.OrderPhotoResp;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yinyong on 2018/12/3.
 */
@Service
@Slf4j
@AllArgsConstructor
public class OrderRecordServiceImpl extends ServiceImpl<OrderRecordMapper, OrderRecord> implements OrderRecordService {

    private final OrderRecordMapper orderRecordMapper;

    @Override
    public Page<OrderPhotoResp> queryMyOrderPhoto(Integer pageNum, Integer pageSize) {

        List<OrderPhotoResp> list = orderRecordMapper.queryMyOrderPhoto(SessionUtils.getCustomerId(), (pageNum - 1) * pageSize, pageSize);
        Integer count = orderRecordMapper.queryMyOrderPhotoCount(SessionUtils.getCustomerId(), (pageNum - 1) * pageSize, pageSize);

        Page<OrderPhotoResp> photoRespPage = new Page<>(pageNum, pageSize, count);
        photoRespPage.setRecords(list);
        return photoRespPage;

    }
}
