package com.gogirl.application.order.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.order.serve.MultiPaymentType;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.user.customer.CustomerBalanceRecord;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceRecordMapper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/21 4:05 下午
 */
@ActiveProfiles("prod")
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class OrderManageServiceImplTest {


    @Resource
    OrderManageMapper orderManageMapper;
    @Resource
    CustomerBalanceRecordMapper customerBalanceRecordMapper;

    @Test
    public void test1() {
        List<OrderManage> orderManageList = orderManageMapper.selectList(new LambdaQueryWrapper<OrderManage>()
                .eq(OrderManage::getPaymentType, 12)
                .isNull(OrderManage::getMultiplePaymentType));

        orderManageList.forEach(orderManage -> {
            CustomerBalanceRecord customerBalanceRecord = customerBalanceRecordMapper.selectOne(new LambdaQueryWrapper<CustomerBalanceRecord>()
                    .eq(CustomerBalanceRecord::getOrderId, orderManage.getId()));

            BigDecimal cardAmount = new BigDecimal(customerBalanceRecord.getOrderAmount()).divide(new BigDecimal(100), 2, RoundingMode.HALF_DOWN);
            BigDecimal wxAmount = orderManage.getTotalPaymentAmount().subtract(cardAmount);

            orderManage.setMultiplePaymentType(JsonUtilByFsJson.beanToJson(Lists.newArrayList(
                    MultiPaymentType.builder()
                            .type(1)
                            .price(wxAmount)
                            .build(),
                    MultiPaymentType.builder()
                            .type(2)
                            .price(cardAmount)
                            .build()
            )));
            orderManageMapper.updateById(orderManage);
        });
    }

}
