package com.gogirl.shared.admin.techcnian;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class AdminTechnicianScoreResp implements Serializable {

    private Integer technician_id;//:70

    @ApiModelProperty("信息填写完整度")
    private BigDecimal avg_data_integrity;//:22.857143

    @ApiModelProperty("信息填写完整度")
    private String avg_data_integrity_str;//:"23.00 %"

    @ApiModelProperty("服务时长达标率")
    private BigDecimal service_criterion_proportion;//:0.2857

    @ApiModelProperty("服务时长达标率")
    private String service_criterion_proportion_str;//:"29.00 %"

    @ApiModelProperty("美甲师姓名")
    private String technician_name;//:"卢丹彤"

    @ApiModelProperty("店铺名")
    private String store_name;//:"gogirl天河南店"

    @JsonFormat
    private LocalDateTime entry_time;//:"2019-02-21T08:00:00"

    private String grade;//:"中级美甲师"

    private String jobs;//:"美甲师,美睫师,店长"

    private String mobile;//:"13725950791"

    private Integer status;//:1

    @ApiModelProperty("总服务次数")
    private Integer total_service_count;//:11

    @ApiModelProperty("总服务客户")
    private Integer total_client_count;//:8

    @ApiModelProperty("复购客户数")
    private Integer total_repeat_purchase_client_count;//:5

    @ApiModelProperty("复购客户比率")
    private BigDecimal repeat_purchase_client_roportion;//:0.625

    @ApiModelProperty("复购客户比率")
    private String repeat_purchase_client_roportion_str;//:"62.50 %"

    @ApiModelProperty("平均服务金额")
    private BigDecimal average_amount;//:97.14

    @ApiModelProperty("累计业绩")
    private BigDecimal total_achievement;//:1370

    @ApiModelProperty("开卡数量")
    private Integer card_count;//:null

    @ApiModelProperty("开卡率")
    private BigDecimal card_roportion;//:0

    @ApiModelProperty("开卡率")
    private String card_roportion_str;//:"0.00 %"

    @ApiModelProperty("开卡金额")
    private BigDecimal card_amount;//:null

    @ApiModelProperty("预约次数")
    private Integer sch_count;//:15

    @ApiModelProperty("流失次数")
    private Integer sch_loss_count;//:4

    @ApiModelProperty("投诉次数")
    private Integer complaint_count;//:null

    @ApiModelProperty("好评次数")
    private Integer praise_count;//:2

    private Integer external_count;//:null

    @ApiModelProperty("好评率")
    private BigDecimal praise_proportion;//:0.1818

    @ApiModelProperty("好评率")
    private String praise_proportion_str;//:"18.18 %"

    @ApiModelProperty("投诉率")
    private BigDecimal complaint_proportion;//:null

    @ApiModelProperty("好评率")
    private String complaint_proportion_str; //:""
}
