package com.gogirl.interfaces.user.customer;

import com.gogirl.application.common.xcx.GogirlTokenService;
import com.gogirl.application.user.investigation.BaseQuestionService;
import com.gogirl.domain.user.investigation.BaseQuestion;
import com.gogirl.domain.user.investigation.OrderQuestionOption;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.shared.store.SubmitTestPaperReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@Api(tags = "美甲服务问卷调查接口")
@RestController
@AllArgsConstructor
public class TestPaperController {

    private final BaseQuestionService baseQuestionService;
    private final GogirlTokenService gogirlTokenService;

    @ApiOperation("获取调查问卷")
    @GetMapping("/customer/testPaper/getTestPaper")
    public JsonResult<List<BaseQuestion>> getTestPaper(@RequestHeader String token) {

        Integer currentCustomerId = Optional.ofNullable(gogirlTokenService.getByToken(token).getCustomerId()).orElseThrow(() -> new RRException(500, "token不存在"));
        List<BaseQuestion> list = baseQuestionService.getTestPaper(currentCustomerId);
        return JsonResult.success(list);
    }

    @ApiOperation("提交调查问卷")
    @PostMapping("/customer/testPaper/submitTestPaper")
    public JsonResult<Integer> submitTestPaper(@RequestHeader String token,
                                               @RequestBody SubmitTestPaperReq cmd) {

        Integer currentCustomerId = Optional.ofNullable(gogirlTokenService.getByToken(token).getCustomerId())
                .orElseThrow(() -> new RRException(500, "token不存在"));

        List<OrderQuestionOption> list = cmd.getList();
        list.forEach(orderQuestionOption -> orderQuestionOption.setCustomerId(currentCustomerId));
        baseQuestionService.submitTestPaper(currentCustomerId, list);
        return JsonResult.success();
    }
}
