package com.gogirl.infrastructure.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 3:22 下午
 */
@FeignClient(url = "http://localhost:8080/api/order",name = "testFeign",fallback = TestFeign.TestFeignFallback.class)
public interface TestFeign {

    @GetMapping("/test")
    String test();

    @Component
    class TestFeignFallback implements TestFeign{

        @Override
        public String test() {
            return null;
        }
    }
}
