package com.gogirl.domain.market.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 优惠券限定使用店铺
 * </p>
 *
 * @author robbendev
 * @since 2020-06-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="CouponStore对象", description="优惠券限定使用店铺")
public class CouponStore implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "卡券配置id")
    private Integer couponId;

    @ApiModelProperty(value = "卡券能够使用的店铺id")
    private Integer storeId;


}
