package com.gogirl.application.store.oa.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.oa.IOverTimeRecordService;
import com.gogirl.domain.store.oa.OverTimeRecord;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.store.oa.OverTimeRecordMapper;
import com.gogirl.shared.store.OrderTimeRecordPageQuery;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;

/**
 * <p>
 * 加班记录表 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-23
 */
@Service
public class OverTimeRecordServiceImpl extends ServiceImpl<OverTimeRecordMapper, OverTimeRecord> implements IOverTimeRecordService {

    @Override
    public IPage<OverTimeRecord> queryPage(OrderTimeRecordPageQuery qry) {
        Calendar cale = Calendar.getInstance();

        cale.add(Calendar.MONTH, 0);
        cale.set(Calendar.DAY_OF_MONTH, 1);
        Date firstDay = cale.getTime();
        Date paramDate = new Date(firstDay.getTime() - 7 * 24 * 60 * 60 * 1000);
        IPage<OverTimeRecord> page = new Page<>();
        page = baseMapper.selectPage(page, new LambdaQueryWrapper<OverTimeRecord>()
                .eq(OverTimeRecord::getTechnicianId, SessionUtils.getTechnicianId())
                .gt(OverTimeRecord::getLeftTimeLength, 0)
                .ge(OverTimeRecord::getStartTime, paramDate.getTime())
                .ge(OverTimeRecord::getEndTime, paramDate.getTime()));
        return page;
    }
}
