package com.gogirl.application.store.complaint.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.complaint.IRecentDeductedComplaintScoreService;
import com.gogirl.domain.store.complaint.RecentDeductedComplaintScore;
import com.gogirl.infrastructure.mapper.store.complaint.RecentDeductedComplaintScoreMapper;
import org.springframework.stereotype.Service;

import java.time.LocalDate;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-20
 */
@Service
public class RecentDeductedComplaintScoreServiceImpl extends ServiceImpl<RecentDeductedComplaintScoreMapper, RecentDeductedComplaintScore> implements IRecentDeductedComplaintScoreService {

    @Override
    public void syncRecentDeductedComplaintScore() {
        LocalDate localDate = LocalDate.now().minusDays(30);
        baseMapper.delete(new LambdaQueryWrapper<>());
        baseMapper.syncRecentDeductedComplaintScore(localDate);
    }
}
