package com.gogirl.application.product.mall.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.mall.MallCategoryService;
import com.gogirl.domain.product.mall.MallCategory;
import com.gogirl.infrastructure.mapper.order.mall.CategoryMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@AllArgsConstructor
public class MallCategoryServiceImpl extends ServiceImpl<CategoryMapper, MallCategory> implements MallCategoryService {


    @Override
    public List<MallCategory> getCategoryTreeList() {
        List<MallCategory> mallCategoryList = baseMapper.getCategoryTreeList();
        return this.listToTree(mallCategoryList);
    }

    @Override
    public List<MallCategory> getCategoryList(Long categoryId) {
        List<MallCategory> list = this.getCategoryTreeList();
        List<MallCategory> result = new ArrayList<>();
        findSubTree(list, categoryId, result);
        return result;
    }

    /**
     * 找子🌲
     *
     * @param list
     * @param subTreeId
     */
    private void findSubTree(List<MallCategory> list, Long subTreeId, List<MallCategory> result) {

        for (MallCategory mallCategory : list) {
            if (mallCategory.getChildList() == null) {
                mallCategory.setChildList(new ArrayList<>());
            }
            if (mallCategory.getId().equals(subTreeId)) {
                result.addAll(mallCategory.getChildList());
            }
            findSubTree(mallCategory.getChildList(), subTreeId, result);
        }
    }

    /**
     * 商品分类列表转成树形
     *
     * @param list 商品分类列表
     * @return 商品分类树🌲
     */
    private List<MallCategory> listToTree(List<MallCategory> list) {
        //用递归找子。
        List<MallCategory> treeList = new ArrayList<>();
        for (MallCategory tree : list) {
            if (tree.getParentId() == 0) {
                MallCategory child = findChildren(tree, list);
                if (child.getCount() > 0) {
                    treeList.add(child);
                }
            }
        }
        return treeList;
    }


    /**
     * 递归构建子树
     *
     * @param tree 根结点
     * @param list 商品分类列表
     * @return 商品分类树🌲
     */
    private MallCategory findChildren(MallCategory tree, List<MallCategory> list) {
        for (MallCategory node : list) {
            if (node.getParentId().equals(tree.getId())) {
                if (tree.getChildList() == null) {
                    tree.setChildList(new ArrayList<>());
                }
                MallCategory child = findChildren(node, list);
                if (child.getCount() > 0) {
                    int count = tree.getCount() + child.getCount();
                    tree.getChildList().add(child);
                    tree.setCount(count);
                }
            }
        }
        return tree;
    }

}
