package com.gogirl.application.dashboard;

import com.gogirl.shared.admin.AdminPage;
import com.gogirl.shared.admin.dashboard.req.*;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResult;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResultPageApiRequest;
import com.gogirl.shared.admin.techcnian.AdminTechnicianScoreResp;
import com.gogirl.shared.admin.techcnian.GetTechnicianPageRequest;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/31 9:13 上午
 */
public interface DashboardService {

    /**
     * <p>
     * 见doc文档getStoreTrendApi
     * </p>
     *
     * @param request
     * @return
     */
    GetStoreTrendApiResp getStoreTrendApi(GetStoreTrendApiRequest request);

    /**
     * <p>
     * 见doc文档getStoreListApi
     * </p>
     *
     * @param request
     * @return
     */
    List<Map<String, Object>> getStoreListApi(GetStoreListApiRequest request);

    /**
     * <p>
     * 见doc文档preStorageSumApi
     * </p>
     *
     * @param request
     * @return
     */
    Map<String, Object> preStorageSumApi(PreStorageSumApiRequest request);

    /**
     * <p>
     * 见doc文档revenueSumByTypeApi
     * </p>
     *
     * @param request
     * @return
     */
    Map<String, Object> revenueSumByTypeApi(RevenueSumByTypeApiRequest request);

    /**
     * <p>
     * 见doc文档revenueTypeListApi
     * </p>
     *
     * @param request
     * @return
     */
    List<Map<String, Object>> revenueTypeListApi(RevenueTypeListRequest request);

    /**
     * <p>
     * 见doc文档revenueSumApi
     * </p>
     *
     * @param request
     * @return
     */
    List<Map<String, Object>> revenueSumApi(RevenueSumApiRequest request);

    /**
     * <p>
     * 美甲师信息
     * </p>
     *
     * @param request
     * @return
     */
    AdminPage<AdminTechnicianScoreResp> getTechnicianPage(GetTechnicianPageRequest request);

    /**
     * <p>
     * 美甲师业绩
     * </p>
     *
     * @param request
     * @return
     */
    AdminPage<AchievementsPersonaResult> achievementsPersonaResultPageApi(AchievementsPersonaResultPageApiRequest request);

    /**
     * <p>
     * 1级/2级/3级 sku
     * </p>
     *
     * @param request
     * @return
     */
    List<Map<String, Object>> revenueServiceListApi(RevenueServiceListApiRequest request);
}
