package com.gogirl.shared.market;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class TimesCardCustomerRelevanceDTO implements Serializable {

    private Integer id;

    @ApiModelProperty("次卡种类id")
    private Integer cardTypeId;

    @ApiModelProperty("次卡名字")
    private String name;

    @ApiModelProperty("次卡持有人id")
    private Integer customerId;

    @ApiModelProperty("单次优惠价格")
    private BigDecimal discountAmount;

    @ApiModelProperty("单次算业绩价格")
    private BigDecimal payAmount;

    @ApiModelProperty("购卡时间")
    private Date createTime;

    @ApiModelProperty("已使用次数")
    private Integer usedTimes;

    @ApiModelProperty("总共使用次数")
    private Integer sumTimes;

    @ApiModelProperty("有效期,开始时间")
    private Date validStartTime;

    @ApiModelProperty("有效期,截止时间")
    private Date validEndTime;

    @ApiModelProperty("购卡推荐人")
    private String refereeId;

    @ApiModelProperty("1正常使用;2.次数用完;3.已过期;")
    private Integer status;

}
