package com.gogirl.infrastructure.service.push.impl;

import com.gogirl.application.common.xcx.impl.AccessTokenService;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.config.config.WxPayConfig;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.service.push.PushMsgService;
import com.gogirl.shared.wx.*;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 小程序订阅消息实现消息推送服务
 *
 * @Author robbendev
 * @Description //TODO
 * @Date 2019/12/29
 **/
@Service
@AllArgsConstructor
@Slf4j
public class MiniappPushMsgServiceImpl implements PushMsgService {

    private final AccessTokenService accessTokenService;

    @Override
    public void sendScheduleMsg(String openId, String scheduleName, Date arriveTime, String departmentName, String address,Integer brandId) {
        log.info("推送预约提醒订阅消息");
        String tips;
        if ((arriveTime.getTime() - System.currentTimeMillis()) / 1000 / 60 < 50) {
            tips = "温馨提示：超时15分钟预约将自动取消";
        } else {
            tips = "距预约剩余1小时，请准时到店，超时将取消";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.send(WxSubscribeMessageRequest.builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken(brandId).getAccessToken())
                .page("pages/mine/appointment-list")
                .templateId(WxPayConfig.brandMap.get(brandId).getScheduleTpl())
                .data(ScheduleSubscribeMsgData.builder()
                        //预约时间
                        .time2(new MessageValue(sdf.format(arriveTime)))
                        //地址
                        .thing4(new MessageValue(address))
                        //预约项目
                        .thing7(new MessageValue(scheduleName))
                        //预约门店
                        .thing8(new MessageValue(departmentName))
                        //温馨提示
                        .thing9(new MessageValue(tips))
                        .build())
                .build());
    }

    @Async
    @Override
    public void sendOverScheduleMsg(String openId,
                                    String scheduleName,
                                    Date arriveTime,
                                    String departmentName,
                                    String address,
                                    Integer brandId) {

        log.info("推送超时取消订阅消息");

        String tips = "您已超时15分钟，预约已取消，请重新预约";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.send(WxSubscribeMessageRequest.builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken(brandId).getAccessToken())
                .page("pages/mine/appointment-list")
                //模板id
                .templateId(WxPayConfig.brandMap.get(brandId).getOverScheduleTpl())
                .data(OverScheduleSubscribeMsgData.builder()
                        //预约时间
                        .date2(new MessageValue(sdf.format(arriveTime)))
                        //门店地址
                        .thing4(new MessageValue(address))
                        //预约项目
                        .thing1(new MessageValue(scheduleName))
                        //预约门店
                        .thing3(new MessageValue(departmentName))
                        //温馨提示
                        .thing5(new MessageValue(tips))
                        .build())
                .build());

    }



    @Override
    public void sendPaySuccessMsg(Integer orderId,
                                  String openId,
                                  String payType,
                                  Date paymentTime,
                                  BigDecimal paymentAmount,
                                  BigDecimal balance,
                                  Integer brandId) {
        log.info("推送支付成功消息 订单id：{}", orderId);

        String tips = "点击即可查看详情，如有疑问请联系客服";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.send(WxSubscribeMessageRequest.builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken(brandId).getAccessToken())
                .page("pages/mine/serve-details")
                //模板id
                .templateId(WxPayConfig.brandMap.get(brandId).getPaySuccessTpl())
                .data(PaySuccessSubscribeMsgData.builder()
                        //支付时间
                        .date5(new MessageValue(sdf.format(paymentTime)))
                        //金额
                        .amount3(new MessageValue("￥" + paymentAmount.toString()))
                        //支付方式
                        .thing7(new MessageValue(payType))
                        //会员余额
                        .amount8(new MessageValue("￥" + balance.toString()))
                        //温馨提示
                        .thing9(new MessageValue(tips))
                        .build())
                .build());

    }


    @Override
    public void sendOrderPayNotifyMsg(Integer orderId,
                                      String openId,
                                      String serveName,
                                      String orderNo,
                                      BigDecimal paymentAmount,
                                      String customerName,
                                      Integer brandId) {

        log.info("支付提醒订阅消息推送 订单id:{}", orderId);

        String tips = "亲，支付完成后请给店员确认哦，谢谢！";
        this.send(WxSubscribeMessageRequest.builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken(brandId).getAccessToken())
                .page("pages/mine/serve-details?orderId=" + orderId)
                //模板id
                .templateId(WxPayConfig.brandMap.get(brandId).getOrderPayNotifyTpl())
                .data(OrderNotifySubscribeMsgData.builder()
                        //订单号
                        .character_string4(new MessageValue(orderNo))
                        //金额
                        .amount3(new MessageValue("￥" + paymentAmount.toString()))
                        //服务名称
                        .thing1(new MessageValue(serveName))
                        //温馨提示
                        .thing6(new MessageValue(tips))
                        .build())

                .build());
    }


    @Override
    public void sendCommentMsg(String openId,
                               Integer orderId,
                               Integer brandId) {

        log.info("推送提醒评价订阅消息，订单id:{}", orderId);
        this.send(WxSubscribeMessageRequest
                .builder()
                .toUser(openId)
                .accessToken(accessTokenService.getAccessToken(brandId).getAccessToken())
                .page("pages/mine/comment?orderId=" + orderId)
                //模板id
                .templateId(WxPayConfig.brandMap.get(brandId).getTestPaperTpl())
                .data(TestPaperMsgData.builder()
                        .thing1(new MessageValue("评价有礼"))
                        .amount2(new MessageValue("￥10"))
                        .thing3(new MessageValue("点击进入小程序评价服务即可领取成功哦！"))
                        .build())
                .build());

    }

    private <T> JsonResult<Void> send(@RequestBody WxSubscribeMessageRequest<T> request) {

        String url = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=" + request.getAccessToken();

        Map<String, Object> map = new HashMap<>();
        map.put("data", request.getData());
        map.put("template_id", request.getTemplateId());
        map.put("touser", request.getToUser());
        map.put("page", request.getPage());

        log.info("推送订阅消息参数：{}", JsonUtilByFsJson.beanToJson(map));

        String jsonResp = new RestTemplate().postForEntity(url, map, String.class).getBody();

        log.info("推送订阅消息响应：{}", jsonResp);
        return JsonResult.success();
    }
}
