package com.gogirl.domain.product.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 款式主题
 * </p>
 *
 * @author robbendev
 * @since 2021-01-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BaseProduceSubject对象", description = "款式主题")
public class BaseProduceSubject implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private String name;

    @TableField(value = "`describe`")
    private String describe;

    private String picturePath;

    private String code;

    @ApiModelProperty(value = "是否官网显示")
    private Boolean hasIndexShow;

    @ApiModelProperty(value = "品牌id")
    private Integer brandId;


}
