package com.gogirl.domain.market.discount;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gogirl.infrastructure.common.annotation.DictParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;


@ApiModel("闲时折扣配置")
@TableName("leisure_discount_config")
@Data
public class LeisureDiscountConfig implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("折扣")
    private BigDecimal discountRate;

    @ApiModelProperty("店铺id")
    private Integer departmentId;

    @ApiModelProperty("开始时间 HH:mm:ss")
    private Time startTime;

    @ApiModelProperty("结束时间 HH:mm:ss")
    private Time endTime;

    @DictParam(dictCode = "LEISURE_DISCOUNT_CONFIG_IS_ENABLED", dictValueParam = "isEnabledStr")
    @ApiModelProperty("是否开启1-开启 2-关闭")
    private Integer isEnabled;

    @TableField(exist = false)
    private String isEnabledStr;

    private Date createTime;

    private Date updateTime;

    @TableField("`limit`")
    private Integer limit;

    @ApiModelProperty("品牌id")
    private Integer brandId;

}
