package com.gogirl.application.common.xcx.impl;


import com.gogirl.application.common.xcx.WechatService;
import com.gogirl.infrastructure.common.config.config.WxPayConfig;
import com.gogirl.infrastructure.common.constant.WxConstants;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.shared.member.Code2SessionResult;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;


@Service
@AllArgsConstructor
public class WechatServiceImpl implements WechatService {

    private final RestTemplate restTemplate;


    @Override
    public Code2SessionResult getCustomerOpenidByCode(String code,Integer brandId) {

        String url = WxConstants.OAuth2_ACCESS_TOKEN_URL
                .replaceAll("APPID", WxPayConfig.brandMap.get(brandId).getCustomerMiniappId())
                .replaceAll("SECRET", WxPayConfig.brandMap.get(brandId).getCustomerMiniappSecret())
                .replaceAll("JSCODE", code);


        String response = restTemplate.postForEntity(url, null, String.class).getBody();
        return JsonUtilByFsJson.jsonToBean(response, Code2SessionResult.class);
    }


    @Override
    public Code2SessionResult getTechnicianOpenidByCode(String code,Integer brandId) {

        String url = WxConstants.OAuth2_ACCESS_TOKEN_URL
                .replaceAll("APPID", WxPayConfig.brandMap.get(brandId).getStoreMiniappId())
                .replaceAll("SECRET", WxPayConfig.brandMap.get(brandId).getStoreMiniappSecret())
                .replaceAll("JSCODE", code);


        String response = restTemplate.postForEntity(url, null, String.class).getBody();
        return JsonUtilByFsJson.jsonToBean(response, Code2SessionResult.class);
    }

}
