package com.gogirl.application.xcx.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.application.xcx.QRCodeService;
import com.gogirl.application.xcx.WechatService;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.infrastructure.service.sms.SmsService;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.member.wx.query.dto.Code2SessionResult;
import lombok.AllArgsConstructor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


@Service
@AllArgsConstructor
public class GogirlTokenServiceImpl implements GogirlTokenService {

    private final RedisTemplate<String, String> redisTemplate;
    private final SmsService smsService;

    @Override
    public void save(GogirlToken gogirlToken) {
        redisTemplate.opsForValue().set(gogirlToken.getToken(), JsonUtilByFsJson.beanToJson(gogirlToken));
    }

    @Override
    public GogirlToken getByToken(String token) {
        String tokenValue = redisTemplate.opsForValue().get(token);
        return JsonUtilByFsJson.jsonToBean(tokenValue, GogirlToken.class);
    }

    @Override
    public void updateByToken(GogirlToken gogirlToken) {
        redisTemplate.opsForValue().set(gogirlToken.getToken(), JsonUtilByFsJson.beanToJson(gogirlToken));
    }

    @Override
    public void remove(String token) {
        redisTemplate.delete(token);
    }

    @Override
    public String getBindCode(String phone) {

        if (!StringUtils.isPhone(phone)) {
            throw new RRException("用户号码格式不正确");
        }
        String code = getNewCode();
        SmsSingleSenderResult result = smsService.sendBindSmsCode(phone, code);

        if (result == null) {
            throw new RRException("验证码发送失败，请重试");
        }
        return code;
    }

    private final CustomerMapper customerMapper;
    private final QRCodeService qrCodeService;

    @Override
    public Customer bindPhoneAndCode(String phone, String code, String realName, Date birthday, String sex) throws Exception {
        GogirlToken gogirlToken = SessionUtils.getCustomerToken();

        Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());
        if (StringUtils.isNotEmpty(realName)) {
            customer.setRealName(realName);
        }
        customer.setBirthday(birthday);
        if (StringUtils.isNotEmpty(sex)) {
            customer.setSex(sex);

        }
        if (StringUtils.isNotEmpty(phone)) {
            String myQrCode = qrCodeService.myQrCode(customer.getId().toString(), phone);
            customer.setMyQrcode(myQrCode);
            customer.setPhone(phone);
        }

        List<Customer> phoneCustomer = customerMapper.selectList(new LambdaQueryWrapper<Customer>()
                .eq(Customer::getPhone, phone));

        if (ListUtil.isNotEmpty(phoneCustomer)) {
            throw new RRException("手机号已经使用");
        }
        //更新用户
        customerMapper.updateById(customer);
        return customer;
    }

    private final WechatService wechatService;
    private final StoreTechnicianMapper storeTechnicianMapper;
    private final StoreManageMapper storeManageMapper;

    @Override
    public void bindTechnicianIdPhone(String phone, String code, String messageCode) {
        Code2SessionResult responseResult = wechatService.getTechnicianOpenidByCode(code);

        if (responseResult.getErrcode() != null) {
            throw new RRException(responseResult.getErrmsg());
        }

        String openid = responseResult.getOpenid();

        StoreTechnician storeTechnician = storeTechnicianMapper.selectOne(new LambdaQueryWrapper<StoreTechnician>().eq(StoreTechnician::getMobile, phone));
        if (storeTechnician == null) {
            throw new RRException("请联系管理员添加美甲师");
        }
        List<StoreManage> storeManageList = storeManageMapper.getTechnicianShopList(storeTechnician.getId());
        if (ListUtil.isEmpty(storeManageList)) {
            throw new RRException("请联系管理员添加美甲师");
        }

        if (StringUtils.isNotEmpty(storeTechnician.getOpenid())) {
            throw new RRException("已经绑定过手机号");
        }
        storeTechnician.setOpenid(openid);
        storeTechnicianMapper.updateById(storeTechnician);
    }


    private String getNewCode() {
        return String.valueOf((int) ((Math.random() * 9 + 1) * 100000));
    }
}
