package com.gogirl.domain.market.coupon;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel("预约卡券订单关联")
@TableName("coupon_order_relevance")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CouponOrderRelevance {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("卡券领取记录表")
    private Integer couponCustomerRelevanceId;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("订单服务id")
    private Integer orderServeId;

    @ApiModelProperty("订单服务名称")
    private String serveName;

    @ApiModelProperty("卡券在这个服务上实支付金额")
    private BigDecimal payForOrderServe;

    @ApiModelProperty("订单服务抵扣金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("卡券配置id")
    private Integer couponId;

    @ApiModelProperty("用户id")
    private Integer customerId;

    @ApiModelProperty("美甲师id")
    private Integer technicianId;

    private String message;

    @ApiModelProperty("1.待确认;2.确认可用;3.确认不可用;4.用户删除;5.美甲师删除")
    private Integer status;

    @ApiModelProperty("确认时间")
    private Date confirmTime;

    @ApiModelProperty("卡券名称")
    private String couponName;

    @TableField(exist = false)
    private Coupon coupon;

    private BigDecimal achievement;
}

