package com.gogirl.shared.user.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class CustomerDTO {

    private Integer id;

    @ApiModelProperty("微信唯一id")
    private String unionid;

    @ApiModelProperty("公众号openid")
    private String openid;

    @ApiModelProperty("微信小程序openid")
    private String openid1;

    @ApiModelProperty("电话号码")
    private String phone;

    @ApiModelProperty("微信昵称")
    private String nickname;

    @ApiModelProperty("弃用 密码")
    private String password;

    @ApiModelProperty("性别")
    private String sex;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("头像url")
    private String headimgurl;

    @ApiModelProperty("微信权限")
    private String privilege;

    @ApiModelProperty("用户状态 目前都是正常")
    private String state;

    @ApiModelProperty("用户注册时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date registerTime;

    @ApiModelProperty("最后一次更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("用户自己录入的真实名字")
    private String realName;

    @ApiModelProperty("生日")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date birthday;

    @ApiModelProperty("首次注册店铺")
    private Integer registerDepartment;

    @ApiModelProperty("店铺端录入的客户名字")
    private String storeRecordRealName;


    @ApiModelProperty("负责人")
    private String responsiblePerson;

    @ApiModelProperty("资料完整度")
    private Double dataIntegrity;

    @ApiModelProperty("用户二维码")
    private String myQrcode;
}
