package com.gogirl.shared.user.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class CustomerBalanceDTO {

    private Integer id;

    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("余额")
    private Integer balance;

    @ApiModelProperty("折扣")
    private Double currentDiscount;

    @ApiModelProperty("首次充值时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date firstChargeTime;

    @ApiModelProperty("最后一次更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("总充值金额")
    private Integer totalCharge;

    @ApiModelProperty("总送金额")
    private Integer totalBestow;

    @ApiModelProperty("总花费金额")
    private Integer totalExpenditure;

    private Integer version;

    @ApiModelProperty("会员级别 ")
    private String level;

    @ApiModelProperty("推荐人")
    private String refereeId;

    @ApiModelProperty("折扣百分比")
    private Double discountRate;
}
