package com.gogirl.shared.market.query.qry;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;


/**
 * 查询可使用的内部券入参
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CanUsedInnerCouponQuery {

    @ApiModelProperty("订单服务id")
    private List<Integer> orderServeIds;

    @ApiModelProperty("用户id")
    private Integer customerId;

    @ApiModelProperty("订单总价")
    private BigDecimal totalPrice;
}
