package com.gogirl.interfaces.product.serve;

import com.gogirl.application.product.serve.BaseFeaturesService;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.product.serve.BaseFeaturesMapper;
import com.gogirl.shared.product.query.dto.ProduceFeaturesDTO;
import com.gogirl.shared.product.query.dto.ServeFeaturesDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@AllArgsConstructor
@Api("首页标签接口")
public class LabelController {

    private final BaseFeaturesService baseFeaturesService;
    private final BaseFeaturesMapper baseFeaturesMapper;

    @ApiOperation("查询首页服务标签")
    @GetMapping("/customer/label/no_queryServeLabel")
    public JsonResult<List<ServeFeaturesDTO>> queryServeFeatures(@RequestParam(required = false) Integer typeId) {
        List<ServeFeaturesDTO> serveFeaturesDTOList = baseFeaturesService.queryServeFeatures(typeId);
        return JsonResult.success(serveFeaturesDTOList);
    }


    @ApiOperation("查询首页款式标签")
    @GetMapping("/customer/label/no_queryProduceLabel")
    public JsonResult<List<ProduceFeaturesDTO>> queryProduceFeatures() {
        List<ProduceFeaturesDTO> produceFeaturesDTOList = baseFeaturesService.queryProduceFeatures();
        return JsonResult.success(produceFeaturesDTOList);
    }

}
