package com.gogirl.infrastructure.subscribe;

import java.math.BigDecimal;
import java.util.Date;

public interface SubscribeService {

    void sendScheduleMsg(String openId, String scheduleName, Date arriveTime, String departmentName, String address);

    /**
     * 预约过期订阅消息发送
     *
     * @param openId         用户openid
     * @param scheduleName   预约项目名称
     * @param arriveTime     预约时间
     * @param departmentName 店铺名称
     * @param address        店铺地址
     */
    void sendOverScheduleMsg(String openId, String scheduleName, Date arriveTime, String departmentName, String address);

    /**
     * 支付成功通知
     *
     * @param openId        用户openid
     * @param payType       支付类型
     * @param paymentTime   支付时间
     * @param paymentAmount 支付金额
     * @param balance       余额
     */
    void sendPaySuccessMsg(String openId, String payType, Date paymentTime, BigDecimal paymentAmount, BigDecimal balance);

    /**
     * 订单待支付提醒
     *
     * @param openId        用户openid
     * @param serveName     服务名称
     * @param orderNo       订单号
     * @param paymentAmount 支付金额
     * @param customerName  用户名字
     */
    void sendOrderPayNotifyMsg(String openId, String serveName, String orderNo, BigDecimal paymentAmount, String customerName);

    void testPaper(String openid1, Integer id);
}
