package com.gogirl.infrastructure.mapper.store.career;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.store.career.Career;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface CareerMapper extends BaseMapper<Career> {

    /**
     * 查询当月充卡数量
     *
     * @param technicianId
     * @param month
     * @return
     */
    Integer queryMonthBalanceCardNum(@Param("technicianId") Integer technicianId, @Param("month") String month);

    /**
     * 查询当月订单总数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryMonthOrderNum(@Param("technicianId") Integer id, @Param("month") String month);

    /**
     * 查询当月服务客户数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryMonthServeCustomerNum(@Param("technicianId") Integer id, @Param("month") String month);

    /**
     * 查询总充卡数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryTotalBalanceCardNum(@Param("technicianId") Integer id, @Param("month") String month);

    /**
     * 查询总服务客户数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryTotalServeCustomerNum(@Param("technicianId") Integer id, @Param("month") String month);

    /**
     * 查询总订单数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryTotalOrderNum(@Param("technicianId") Integer id, @Param("month") String month);


    /**
     * 查询当月复购单数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryMonthAgainOrderNum(@Param("technicianId") Integer id, @Param("month") String month);


    /**
     * 查询总复购单数量
     *
     * @param id
     * @param month
     * @return
     */
    Integer queryTotalAgainOrderNum(@Param("technicianId") Integer id, @Param("month") String month);

    /**
     * 客户总好评
     *
     * @param id
     */
    Double queryTotalPraisePercent(Integer id);

    /**
     * 客户当月好评
     *
     * @param id
     * @param month
     * @return
     */
    Double queryMonthPraisePercent(@Param("id") Integer id, @Param("month") String month);
}
