package com.gogirl.infrastructure.common.util;

import java.lang.reflect.Method;
import java.util.*;

/**
 * 树结构工具类
 *
 * @author mochunrun
 */
public class TreeUtils {

    /**
     * @param dataList         树全量数据
     * @param topIdList        顶级树ID
     * @param idName
     * @param pidName
     * @param addSubMethodName
     * @param filter           关键字过虑
     * @param isNotShowParent  按关键字过虑。如果父级关键字不找不到侧不显示
     * @return
     * @throws Exception
     */
    public static <T, E> List<T> createTree(List<T> dataList, List<String> topIdList, String idName, String pidName, String addSubMethodName, Map<String, Object> filter, boolean isNotShowParent) throws Exception {
        List<T> treeList = new ArrayList<T>();
        if (dataList != null && dataList.size() > 0) {
            Class clazz = dataList.get(0).getClass();
            Method idMethod = clazz.getMethod("get" + captureName(idName));
            Method pidMethod = clazz.getMethod("get" + captureName(pidName));
            Method addSubMethod = clazz.getMethod(addSubMethodName, clazz);
            Map<String, Method> methods = getMethods(clazz, filter);
            Map<String, T> listMap = listToMap(dataList, idMethod);
            //按关键字过滤
            for (T m : dataList) {
                if (checkFilter(m, filter, methods)) {
                    T pm = getParentMenus(listMap, topIdList, m, idMethod, pidMethod, addSubMethod, isNotShowParent, methods, filter);
                    if (pm != null) {
                        if (!treeList.contains(pm)) {
                            treeList.add(pm);
                        }
                    }
                }
            }
        }
        return treeList;
    }

    /**
     * list转为map
     *
     * @param dataList
     * @param idMethod
     * @return
     * @throws Exception
     */
    public static <T> Map<String, T> listToMap(List<T> dataList, Method idMethod) throws Exception {
        Map<String, T> map = new LinkedHashMap<String, T>();
        if (dataList != null) {
            for (T t : dataList) {
                String key = (String) idMethod.invoke(t);
                map.put(key, t);
            }
        }
        return map;
    }


    /**
     * 检查数据
     *
     * @param m
     * @param filter
     * @return
     * @author mochunrun
     * @version 2017年10月27日
     */
    public static <T, E> boolean checkFilter(T m, Map<String, Object> filter, Map<String, Method> methods) throws Exception {
        boolean result = true;
        if (filter == null || filter.size() == 0) {
            return result;
        }
        Iterator it = filter.keySet().iterator();
        while (it.hasNext()) {
            String key = (String) it.next();
            Object keyWords = filter.get(key);
            Object val = methods.get(key).invoke(m);
            if (keyWords == null) {
                continue;
            } else if (val == null) {
                result = false;
                break;
            } else if (keyWords instanceof String) {
                String value = (String) val;
                if (value.toUpperCase().indexOf(keyWords.toString().toUpperCase()) == -1) {
                    result = false;
                    break;
                }
            } else if (keyWords instanceof List) {
                List list = (List) keyWords;
                if (list.size() > 0 && !list.contains(val)) {
                    result = false;
                    break;
                }
            } else if (!val.equals(keyWords)) {
                result = false;
                break;
            }
        }
        return result;
    }

    public static Map<String, Method> getMethods(Class clazz, Map<String, Object> filter) throws Exception {
        Map<String, Method> methods = new HashMap<String, Method>();
        if (filter != null) {
            Iterator it = filter.keySet().iterator();
            while (it.hasNext()) {
                String key = (String) it.next();
                Method method = clazz.getMethod("get" + captureName(key));
                methods.put(key, method);
            }
        }
        return methods;
    }

    /**
     * 获取父级树
     *
     * @param menu
     * @return
     */
    public static <T> T getParentMenus(Map<String, T> listMap, List<String> topIdList, T menu, Method idMethod, Method pidMethod, Method addSubMethod, boolean isNotShowParent, Map<String, Method> methods, Map<String, Object> filter) throws Exception {
        if (menu == null) return null;
        String menupid = (String) pidMethod.invoke(menu);
        if (topIdList != null && topIdList.size() > 0) {
            String menuid = (String) idMethod.invoke(menu);
            if (topIdList.contains(menuid)) {
                return menu;
            }
        } else if ("-1".equalsIgnoreCase(menupid) || "0".equalsIgnoreCase(menupid)) {
            if (StringUtils.isEmpty(menupid)) {
                return null;
            }
            return menu;
        }
        T pm = listMap.get(menupid);
        if (pm == null) return null;
        if (isNotShowParent) {
            //不显示父级
            if (!checkFilter(pm, filter, methods)) {
                //如果父级非关键字内容侧不显示
                return menu;
            }
        }
        addSubMethod.invoke(pm, menu);
        return getParentMenus(listMap, topIdList, pm, idMethod, pidMethod, addSubMethod, isNotShowParent, methods, filter);
    }

    /**
     * 首字母大写
     *
     * @param name
     * @return
     */
    public static String captureName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }
}
