package com.gogirl.infrastructure.common.util;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.infrastructure.common.base.PageReq;

public class PageUtils {

    /**
     * rpc分页入参转换成mp page对象
     *
     * @param <T>            rpc分页入参类型
     * @param pageReq        rpc分页入参
     * @param mallOrderClass
     * @return
     */
    public static <T extends PageReq, C> Page<C> castPageReq(T pageReq, Class<C> mallOrderClass) {
        Page<C> page = new Page<>();
        page.setSize(pageReq.getPageSize());
        page.setCurrent(pageReq.getPageIndex());
        return page;
    }

}
