package com.gogirl.infrastructure.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.util.List;

/**
 * Json工具类
 *
 * @author Dxd
 */
public class JsonUtilByFsJson {

    /**
     * 期望的 JSON 格式
     */
    public static final SerializerFeature[] features = {
            SerializerFeature.WriteMapNullValue, // 输出空置字段
            SerializerFeature.WriteNullListAsEmpty, // list字段如果为null，输出为[]，而不是null
            SerializerFeature.WriteNullNumberAsZero, // 数值字段如果为null，输出为0，而不是null
            SerializerFeature.WriteNullBooleanAsFalse, // Boolean字段如果为null，输出为false，而不是null
            SerializerFeature.WriteNullStringAsEmpty, // 字符类型字段如果为null，输出为""，而不是null
            SerializerFeature.DisableCircularReferenceDetect,
            SerializerFeature.WriteEnumUsingToString
    };

    /**
     * 对返回的 JSON 值做空值过滤
     */
    public static final PropertyFilter allPropertyFilter = new PropertyFilter() {
        @Override
        public boolean apply(Object object, String name, Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof String) {
                String str = (String) value;
                if (StringUtils.isEmpty(str)) {
                    return false;
                }
            }
            return true;
        }
    };

    /**
     * 对返回的 BaseResult 过滤 null 值
     */
    public static final PropertyFilter resultPropertyFilter = new PropertyFilter() {
        @Override
        public boolean apply(Object object, String name, Object value) {
            if (StringUtils.equals("data", name)) {
                if (value == null) {
                    return false;
                }
                if ((value instanceof String) && StringUtils.isEmpty((String) value)) {
                    return false;
                }
            }
            if (StringUtils.equals("totalSize", name) && value == null) {
                return false;
            }
            if (StringUtils.equals("totalPage", name) && value == null) {
                return false;
            }
            if (StringUtils.equals("nextPage", name) && value == null) {
                return false;
            }
            return true;
        }
    };


    /**
     * bean 转换为json（过滤空值）
     *
     * @param src
     * @param <T>
     */
    public static <T> String beanToJsonNotNull(T src) {
        return JSON.toJSONString(src, allPropertyFilter, features);
    }

    /**
     * bean 转换为json（不过滤空值）
     *
     * @param src
     * @param <T>
     * @return
     */
    public static <T> String beanToJson(T src) {
        return JSON.toJSONString(src, features);
    }

    /**
     * result结果转为Json
     *
     * @param src
     * @param <T>
     */
    public static <T> String resultToJson(T src) {
        return JSON.toJSONString(src, resultPropertyFilter, features);
    }

    /**
     * json 转为 Bean
     *
     * @param json
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T jsonToBean(String json, Class clazz) {
        return (T) JSON.parseObject(json, clazz);
    }

    /**
     * json 转为list
     *
     * @param json
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> List<T> jsonToList(String json, Class clazz) {
        return JSON.parseArray(json, clazz);
    }

}
