package com.gogirl.domain.store.store;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 门店数据
 */
@TableName("store_data")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class StoreData {

    @TableId(type = IdType.AUTO)
    private Integer id;

    private Integer departmentId;

    @ApiModelProperty("当月服务客户总数")
    private Integer monthServeCustomerNum;

    @ApiModelProperty("当月服务总次数")
    private Integer monthServeNum;

    @ApiModelProperty("当月订单总数")
    private Integer monthOrderNum;

    @ApiModelProperty("当月开卡总数")
    private Integer monthBalanceCardNum;

    @ApiModelProperty("服务客户总数")
    private Integer totalServeCustomerNum;

    @ApiModelProperty("服务总次数")
    private Integer totalServeNum;

    @ApiModelProperty("订单总数")
    private Integer totalOrderNum;

    @ApiModelProperty("开卡总数")
    private Integer totalBalanceCardNum;

    @ApiModelProperty("客户好评率")
    private Double monthPraisePercent;

    @ApiModelProperty("复购率")
    private Double monthRepurchasePercent;

    @ApiModelProperty("信息录入完整度")
    private Double monthInfoPercent;

    @ApiModelProperty("考勤准时率")
    private Double monthAttendancePercent;

    @ApiModelProperty("客户好评率")
    private Double totalPraisePercent;

    @ApiModelProperty("复购率")
    private Double totalRepurchasePercent;

    @ApiModelProperty("信息录入完整度")
    private Double totalInfoPercent;

    @ApiModelProperty("考勤准时率")
    private Double totalAttendancePercent;

    private String departmentName;

    @TableField(exist = false)
    private List<StoreTradeAmount> storeTradeAmountList;

    @TableField(exist = false)
    private List<StoreTechnicianAchieve> storeTechnicianAchieveList;


    @ApiModelProperty("总业绩排行")
    @TableField(exist = false)
    private List<StoreTechnicianTotalAchieve> storeTechnicianTotalAchieveList;

    @ApiModelProperty("总订单业绩排行")
    @TableField(exist = false)
    private List<StoreTechnicianTotalAchieve> storeTechnicianTotalOrderAchieveList;

    @ApiModelProperty("总开卡业绩排行")
    @TableField(exist = false)
    private List<StoreTechnicianTotalAchieve> storeTechnicianTotalChargeAchieveList;



}
