package com.gogirl.domain.store.store;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gogirl.domain.store.oa.TakeLeaveEvent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel("美甲师消息")
@Data
@TableName("message")
public class Message {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("美甲师id")
    private Integer technicianId;

    @ApiModelProperty("消息分类 1.请假审核 2.排班提醒 3请假申请 4采购信息 5-培训课程 6-假期调整")
    private Integer type;

    @ApiModelProperty("消息时间")
    private Date time;

    @ApiModelProperty("0-未读 1-已读")
    private Integer isRead;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("消息")
    private String content;

    private String paramJson;

    @ApiModelProperty("1-公司公告 2-美甲师消息")
    private Integer tab;

    @TableField(exist = false)
    private Integer unread;

    @TableField(exist = false)
    private TakeLeaveEvent takeLeaveEvent;

}
